# 機能設計書 49-Sequence File

## 概要

本ドキュメントは、Apache Flink の flink-sequence-file モジュールが提供する Hadoop SequenceFile 書き込み機能の設計を記述する。

### 本機能の処理概要

Sequence File フォーマット機能は、Hadoop SequenceFile 形式でキー・バリューペアを書き込むための BulkWriter を提供する。Hadoop の Writable インターフェースに基づくデータ型をサポートし、ブロック圧縮にも対応する。

**業務上の目的・背景**：Hadoop SequenceFile は、Hadoop エコシステムで広く使用されるバイナリファイルフォーマットである。キー・バリュー形式のデータを効率的に保存し、MapReduce ジョブでの入出力フォーマットとして標準的に使用される。圧縮とスプリット可能性を両立させたフォーマットである。

**機能の利用シーン**：
- Hadoop MapReduce ジョブへのデータ出力
- 中間データの永続化
- Hive テーブルの内部ストレージ
- Hadoop エコシステムとの相互運用
- スプリット可能な圧縮データの保存

**主要な処理内容**：
1. SequenceFileWriterFactory: SequenceFile ライターのファクトリ
2. SequenceFileWriter: SequenceFile への書き込み実装
3. SerializableHadoopConfiguration: Hadoop Configuration のシリアライズ
4. 圧縮サポート: NONE、RECORD、BLOCK 圧縮タイプ

**関連システム・外部連携**：
- ファイルシステムコネクタ
- Hadoop MapReduce
- Hive
- HDFS / クラウドストレージ

**権限による制御**：本機能はファイル書き込み処理のため、権限制御はファイルシステムに委譲される。

## 関連画面

本機能はバックエンドのデータ書き込み機能であり、直接関連する画面はない。

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | - |

## 機能種別

- ファイル書き込み
- バルクフォーマット

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| hadoopConf | Configuration | Yes | Hadoop 設定 | null 不可 |
| keyClass | Class<K extends Writable> | Yes | キーのクラス | Writable 実装 |
| valueClass | Class<V extends Writable> | Yes | バリューのクラス | Writable 実装 |
| compressionCodecName | String | No | 圧縮コーデック名 | デフォルト: NO_COMPRESSION |
| compressionType | SequenceFile.CompressionType | No | 圧縮タイプ | デフォルト: BLOCK |

### 入力データソース

- 書き込み: Tuple2<K, V> 形式のキー・バリューペア

### 圧縮タイプ

| タイプ | 説明 |
|--------|------|
| NONE | 圧縮なし |
| RECORD | レコード単位の圧縮 |
| BLOCK | ブロック単位の圧縮（スプリット可能） |

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| sequenceFile | File | Hadoop SequenceFile 形式のファイル |

### 出力先

- ファイルシステム（HDFS、S3、ローカル等）

## 処理フロー

### フローチャート

```mermaid
flowchart TD
    A[Tuple2<K, V>] --> B[SequenceFileWriter]
    B --> C[SequenceFile.Writer]
    C --> D{Compression?}
    D -->|Yes| E[CompressionCodec]
    D -->|No| F[Raw Write]
    E --> G[Compressed SequenceFile]
    F --> H[Uncompressed SequenceFile]
```

### データフロー図

```mermaid
flowchart LR
    subgraph Input
        KV[Tuple2<K, V>]
    end

    subgraph Processing
        Factory[SequenceFileWriterFactory]
        Writer[SequenceFileWriter]
        SeqWriter[SequenceFile.Writer]
    end

    subgraph Output
        File[SequenceFile]
    end

    KV --> Writer
    Factory --> Writer
    Writer --> SeqWriter
    SeqWriter --> File
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-49-01 | Writable 制約 | キーとバリューは Writable インターフェースを実装 | 全処理 |
| BR-49-02 | デフォルト圧縮タイプ | 圧縮タイプ未指定時は BLOCK | 初期化時 |
| BR-49-03 | コーデック未指定 | NO_COMPRESSION で非圧縮 | 圧縮コーデック未指定時 |
| BR-49-04 | hsync フラッシュ | flush() で hsync を呼び出し | フラッシュ時 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| RuntimeException | コーデック未発見 | 無効なコーデック名 | コーデック名確認 |
| IOException | 書き込みエラー | ファイル書き込み失敗 | ファイルパス・権限確認 |
| NullPointerException | パラメータ null | 必須パラメータ未指定 | パラメータ確認 |

## 備考

- Hadoop SequenceFile.Writer を直接ラップ
- 書き込み専用（読み取りはサポートしない）
- StreamingFileSink との組み合わせで使用

---

## コードリーディングガイド

### 推奨読解順序

#### Step 1: ファクトリクラス

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SequenceFileWriterFactory.java | `flink-formats/flink-sequence-file/src/main/java/org/apache/flink/formats/sequencefile/SequenceFileWriterFactory.java` | ファクトリ実装 |

**主要処理フロー**:
- **49行目**: NO_COMPRESSION 定数定義
- **65-68行目**: コンストラクタ（基本）- 非圧縮、BLOCK タイプ
- **79-90行目**: コンストラクタ（圧縮コーデック指定）
- **102-114行目**: コンストラクタ（フル設定）
- **117-130行目**: create() で SequenceFileWriter 生成
- **122-128行目**: SequenceFile.createWriter でライター生成
- **132-146行目**: getCompressionCodec() でコーデック取得
- **136-138行目**: NO_COMPRESSION で null 返却

#### Step 2: ライター実装

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SequenceFileWriter.java | `flink-formats/flink-sequence-file/src/main/java/org/apache/flink/formats/sequencefile/SequenceFileWriter.java` | ライター実装 |

**主要処理**:
- **44-46行目**: コンストラクタで SequenceFile.Writer 設定
- **49-51行目**: addElement() で Tuple2 を append
- **54-56行目**: flush() で hsync 呼び出し
- **59-61行目**: finish() で close 呼び出し

### プログラム呼び出し階層図

```
SequenceFileWriterFactory
├── Constructor
│   ├── SerializableHadoopConfiguration
│   └── checkNotNull validations
├── create()
│   ├── getCompressionCodec()
│   │   └── CompressionCodecFactory.getCodecByName()
│   ├── SequenceFile.createWriter()
│   └── SequenceFileWriter
│       ├── addElement()
│       │   └── SequenceFile.Writer.append()
│       ├── flush()
│       │   └── SequenceFile.Writer.hsync()
│       └── finish()
│           └── SequenceFile.Writer.close()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SequenceFileWriterFactory.java | `flink-formats/flink-sequence-file/src/main/java/org/apache/flink/formats/sequencefile/SequenceFileWriterFactory.java` | ソース | ファクトリ |
| SequenceFileWriter.java | `flink-formats/flink-sequence-file/src/main/java/org/apache/flink/formats/sequencefile/SequenceFileWriter.java` | ソース | ライター |
| SerializableHadoopConfiguration.java | `flink-formats/flink-sequence-file/src/main/java/org/apache/flink/formats/sequencefile/SerializableHadoopConfiguration.java` | ソース | Configuration シリアライザ |
